
Type Demo10Screen Extends TScreen

	Field border:TBorder
	Field agent:TAgent
	Field staticList:TList = CreateList()
	Field flapList:TList = CreateList()
	Field flapTexture:TImage
	Field platformTexture:TImage
	Field shooter:TBallLauncher
	
	Field _firstRun:Int = True
	Method Update(delta:Float)
		If _firstRun Then
			 ScreenManager.Instance().AddScreen(TPauseScreen.Create(GetTitle(), GetDetails()))
			_firstRun = False
		EndIf
		shooter.Update()
		HandleKeyboardInput()
		HandleMouseInput()
		physics.Update(delta)
	End Method
	
	Method Draw(delta:Float)
		border.Draw()
		agent.Draw()
		For Local geom:TGeom = EachIn staticList
			TDrawingHelper.DrawGeom(geom, platformTexture)
		Next
		For Local geom:TGeom = EachIn flapList
			TDrawingHelper.DrawGeom(geom, flapTexture)
		Next
		shooter.Draw()
		DrawMouseSpring()
		If physics.EnableDiagnostics Then
			view.Draw()
		End If
	End Method
	
	Method Load()
		physics = TPhysicsSimulator.Create(Vector2.Create(0, 200))
		view = TPhysicsSimulatorView.Create(physics)

		
		Local center:Vector2 = Vector2.Create(TDemo.gfxWidth / 2.0, TDemo.gfxHeight / 2.0)
		Local borderWidth:Int = TDemo.gfxHeight *.05
		border = TBorder.Create(TDemo.gfxWidth, TDemo.gfxHeight, borderWidth, center)
		border.Load(physics)
		
		agent = TAgent.Create(Vector2.Create(center.X-200, 100))
		agent.SetCollidesWith(CollisionCategories.All)
		agent.Load(physics)
		
		shooter = TBallLauncher.Create(physics, Vector2.Create(center.X, 700), Vector2.Create(0, - 1), 800)
		
		' create the static platforms that will host the angle limit joints.
		' these platforms need not be static for the angle limit to work though, purely for demoing purposes.
		Local bWidth:Int = 300
		Local bHeight:Int = 25
		platformTexture = TDrawingHelper.CreateRectangleTexture(bWidth, bHeight, TColor.White, TColor.Black)
		MidHandleImage(platformTexture)
		Local leftPlatBody:TBody = TBodyFactory.CreateRectangleBody(physics, bWidth, bHeight, 1)
		Local leftPlatGeom:TGeom = TGeomFactory.CreateRectangleGeom(physics, leftPlatBody, bWidth, bHeight)
		staticList.AddLast(leftPlatGeom)
		leftPlatBody.SetStatic(True)
		leftPlatBody.SetPosition(Vector2.Create(250, 500))
		
		Local rightPlatBody:TBody = TBodyFactory.CloneBody(physics, leftPlatBody)
		Local rightPlatGeom:TGeom = TGeomFactory.CloneGeom(physics, rightPlatBody, leftPlatGeom)
		rightPlatBody.SetPosition(Vector2.Create(1024 - 250, 500))
		staticList.AddLast(rightPlatGeom)
		
		' create flaps that will be angle limited
		Local fWidth:Int = 100
		Local fHeight:Int = 20
		flapTexture = TDrawingHelper.CreateRectangleTexture(fWidth, fHeight, TColor.Red, TColor.Black)
		MidHandleImage(flapTexture)
		Local leftFlapBody:TBody = TBodyFactory.CreateRectangleBody(physics, fWidth, fHeight, 1)
		Local leftFlapGeom:TGeom = TGeomFactory.CreateRectangleGeom(physics, leftFlapBody, fWidth, fHeight)
		flapList.AddLast(leftFlapGeom)
		leftFlapBody.SetPosition(Vector2.Create(450, 500))
		
		Local rightFlapBody:TBody = TBodyFactory.CloneBody(physics, leftFlapBody)
		Local rightFlapGeom:TGeom = TGeomFactory.CloneGeom(physics, rightFlapBody, leftFlapGeom)
		rightFlapBody.SetPosition(Vector2.Create(1024 - 450, 500))
		flapList.AddLast(rightFlapGeom)
		
		' create angle limit joints along with revolute joints
		TJointFactory.CreateRevoluteJoint(physics, leftPlatBody, leftFlapBody, Vector2.Create(400, 500))
		TJointFactory.CreateAngleLimitJoint(physics, leftPlatBody, leftFlapBody, 1.5 * Pi, 2 * Pi)
		leftPlatGeom.SetCollisionGroup(100)
		leftFlapgeom.SetCollisionGroup(100)
		leftFlapBody.SetRotation(2 * Pi)
		
		TJointFactory.CreateRevoluteJoint(physics, rightPlatBody, rightFlapBody, Vector2.Create(1024 - 400, 500))
		TJointFactory.CreateAngleLimitJoint(physics, rightPlatBody, rightFlapbody, 0, Pi / 2)
		rightPlatgeom.SetCollisionGroup(200)
		rightFlapGeom.SetCollisionGroup(200)
		
	End Method
	
	Method Unload()
		
	End Method
	
	Method HandleKeyboardInput()
		Local forceAmount:Float = 3000
		Local force:Vector2 = Vector2.Zero() 
		
		If KeyDown(KEY_A) Then force.X:+- forceAmount
		If KeyDown(KEY_S) Then force.Y:+forceAmount
		If KeyDown(KEY_D) Then force.X:+forceAmount
		If KeyDown(KEY_W) Then force.Y:+- forceAmount
		agent.agentBody.ApplyForce(force) 
		
		Local torqueAmount:Float = 14000
		Local torque:Float = 0
		If KeyDown(KEY_LEFT) Then torque:-torqueAmount
		If KeyDown(KEY_RIGHT) Then torque:+torqueAmount
		agent.agentBody.ApplyTorque(torque) 
		
		If KeyHit(KEY_F1) Then
			physics.EnableDiagnostics = Not physics.EnableDiagnostics
		End If
	End Method
	
	Method OnEscapeKeyHit()
		ScreenManager.Instance().AddScreen(TPauseScreen.Create(GetTitle(), GetDetails())) 
	End Method
	
	Method GetTitle:String()
		Return "Angle limit Joints"
	End Method
	
	Method GetDetails:TStringBuilder()
		Local sb:TStringBuilder = New TStringBuilder
		sb.AppendLine("Angle Limit Joints can be used to give two bodies ")
		sb.AppendLine("a limited range of rotational movement relative to each other.")
		sb.AppendLine("This demo shows, with angle limit joints and revolute joints,")
		sb.AppendLine("trap door hinge-like behavior. Angle limit joints are not limited")
		sb.AppendLine("to just static bodies and could, for example, to be used to create")
		sb.AppendLine("a dynamic 2D ragdoll that has humanoid limb rotation constraints.")
		sb.AppendLine("Keyboard:")
		sb.AppendLine("  -Rotate : left and right arrows")
		sb.AppendLine("  -Move : A,S,D,W")
		sb.AppendLine("")
		sb.AppendLine("Mouse:")
		sb.AppendLine("  -Hold down left button and drag") 
		Return sb
	End Method
End Type
